/*------------ INCLUDE FILES ----------------*/

#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/graphics.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

/*---------- DEFINES ------------*/

#define MANDELBROT  0
#define JULIA	    1

/*---------- Structure Pointer Declarations ----------*/

struct IntuitionBase *IntuitionBase;
struct GfxBase *GfxBase;

/*---------- Structure Definitions -----------*/

struct complex {
   DOUBLE r;
   DOUBLE i;
};

struct ComplexRange {
   DOUBLE rmin, rmax;
   DOUBLE imin, imax;
};

/*------------------ GENERAL FUNCTIONS -----------------*/

LONG OpenLibraries(void)
{
   IntuitionBase = (struct IntuitionBase *) OpenLibrary("intuition.library",33);
   if(!IntuitionBase) return FALSE;

   GfxBase = (struct GfxBase *) OpenLibrary("graphics.library",33);
   if(!GfxBase) return FALSE;

   return TRUE;
}   /* OpenLibraries */


void CloseLibraries (void)
{
   if (IntuitionBase) CloseLibrary((struct Library *)IntuitionBase);
   if (GfxBase) CloseLibrary((struct Library *)GfxBase);
} /* CloseLibraries () */
